package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ResWithdrawApplyPayload extends TwCommonPayload {

    @ApiModelProperty("申请人id")
    private Long applyUserId;

    @ApiModelProperty("申请人")
    private String applyUserName;

    @ApiModelProperty("提现单号")
    private String withdrawNo;

//    @ApiModelProperty("审批状态")
//    private String apprStatus;

    @ApiModelProperty("资源类型")
    private String resType;

    @ApiModelProperty("提现当量")
    private BigDecimal withdrawEqva;

    @ApiModelProperty("提现金额")
    private BigDecimal withdrawAmt;

    @ApiModelProperty("调整提现金额")
    private BigDecimal adjWithdrawAmt;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("提现申请单明细")
    List<ResWithdrawApplyDetailPayload> detailPayloadList;

}
