package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Getter
@Setter
public class TServerApplyPayload extends TwCommonPayload implements Serializable {
    /** 申请人 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /** 申请时间 */
    @ApiModelProperty("申请时间")
    private LocalDate applyDate;
    /** 申请bu */
    @ApiModelProperty("申请bu")
    private Long applyBuId;
    /** 使用人姓名 */
    @ApiModelProperty("使用人姓名")
    private Long userResId;
    /** 使用bu */
    @ApiModelProperty("使用bu")
    private Long userBuId;
    /** 用途 */
    @ApiModelProperty("用途")
    private String purpose;
    /** 服务器类型 */
    @ApiModelProperty("服务器类型")
    private String type;
    /** 服务器品牌 */
    @ApiModelProperty("服务器品牌")
    private String brand;
    /** 使用范围 */
    @ApiModelProperty("使用范围")
    private String useScope;
    /** 预计费用 */
    @ApiModelProperty("预计费用")
    private BigDecimal expectAmt;
    /** 费用承担bu */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;
    /** CPU */
    @ApiModelProperty("CPU")
    private String cpu;
    /** 内存 */
    @ApiModelProperty("内存")
    private String memory;
    /** 硬盘 */
    @ApiModelProperty("硬盘")
    private String hardDisk;
    /** 系统类型 */
    @ApiModelProperty("系统类型")
    private String sysType;
    /** 生效日期 */
    @ApiModelProperty("生效日期")
    private LocalDate effectiveDate;
    /** 使用日期开始 */
    @ApiModelProperty("使用日期开始")
    private LocalDate useDateStart;
    /** 使用日期结束 */
    @ApiModelProperty("使用日期结束")
    private LocalDate useDateEnd;
    /** 采购合同id */
    @ApiModelProperty("采购合同id")
    private Long purchaseConId;
    /** 申请编号 */
    @ApiModelProperty("申请编号")
    private String applyNo;
    /** 申请状态 */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /** 服务器名称 */
    @ApiModelProperty("服务器名称")
    private String serverName;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;
}
