package com.elitesland.tw.tw5.api.prd.partner.common.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;

import java.util.List;
import java.util.Map;

/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BookAccountService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BookAccountVO}>
     */
    PagingVO<BookAccountVO> queryPaging(BookAccountQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BookAccountVO}>
     */
    List<BookAccountVO> queryListDynamic(BookAccountQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BookAccountVO}
     */
    BookAccountVO queryByKey(Long key);

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookAccountVO}
     */
    BookAccountVO queryDefaultByBookId(Long bookId);
    /**
     * 根据bookIdList查询所有
     *
     * @param bookIdList bookId
     * @return {@link BookAccountVO}
     */
    List<PrdAbAccountPayload> queryTwBookAccountListByBookId(List<Long> bookIdList);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookAccountVO}
     */
    BookAccountVO insert(BookAccountPayload payload, Boolean logFlag);
    /**
     * 批量新增
     *
     * @param voList 单据数据
     * @return {@link BookAccountVO}
     */
    void batchInsert(List<BookAccountVO> voList);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookAccountVO}
     */
    BookAccountVO update(BookAccountPayload payload,Boolean logFlag);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag);

    //逻辑删除（直接删除 不关心默认值的处理）
    void deleteSoftBykeys(List<Long> keys,Long bookId,Long partnerId);
    /**
     * 查询数量
     *
     * @param query 单据数据
     * @return Long 条数
     */

    Long count(BookAccountQuery query);

    /**
     * 逻辑删除
     *
     * @param bookId 地址薄id
     * @return Long 条数
     */
    void deleteByBookId(Long bookId);

    /**
     * 根据bookIdList查询银行账号
     *
     * @param bookIdList bookIdList
     * @return {@link List< BookAccountVO >}
     */
    Map<Long,List<BookAccountVO>> queryByBookIdList(List<Long> bookIdList);

    /**
     * 根据idList查询银行账号
     *
     * @param idList bookIdList
     * @return {@link List< BookAccountVO >}
     */
    Map<Long,List<BookAccountVO>> queryByIdList(List<Long> idList);

    /**
     * 查询内部公司的银行账号
     *
     * @return {@link List< BookAccountVO >}
     */
    List<BookAccountVO> queryInternalList(BookAccountQuery bookAccountQuery);
    /**
     * 批量保存
     *
     */
    void saveAll(List<BookAccountVO> bookAccountVOList);
}
