package com.elitesland.tw.tw5.api.prd.partner.strategy.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 分级策略模型配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Getter
@Setter
public class BusinessStrategyModelQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 模型编号 精确 */
    @ApiModelProperty("模型编号")
    private String modelNo;
    /** 模型名称 精确 */
    @ApiModelProperty("模型名称")
    private String modelName;
    /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] 精确 */
    @ApiModelProperty("模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]")
    private String modelType;
    /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] 精确 */
    @ApiModelProperty("是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]")
    private Boolean standaryFlag;
    /** 开始时间 精确 */
    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;
    /** 结束时间 精确 */
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;
    /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE] 精确 */
    @ApiModelProperty("数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]")
    private String source;
    /** 时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE] */
    @ApiModelProperty("时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]")
    private String dateRange;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 精确 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 精确 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
