package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 分级策略-客户查询
 *
 * @author wangly
 * @date 2023-06-25
 */
@Getter
@Setter
public class BusinessStrategyCustomerVO extends BaseViewModel implements Serializable {

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;

    /** 组织规模 udc[crm:customer_scale] */
    @ApiModelProperty("组织规模 udc[crm:customer_scale]")
    private String organizationScale;

    /**
     * 与公司紧密度 udc[crm:cust_oper:tightness]
     */
    @ApiModelProperty("与公司紧密度 udc[crm:cust_oper:tightness]")
    private String companyTightness;

    /**
     * 行业地位 udc[crm:cust_oper:cust_industry]
     */
    @ApiModelProperty("行业地位 udc[crm:cust_oper:cust_industry]")
    private String industryStand;

    /**
     * 经营策略 udc[crm:cust_oper:strategy]
     */
    @ApiModelProperty("经营策略 udc[crm:cust_oper:strategy]")
    private String businessStrategy;

    /**
     * 业务伙伴id business_partner.id
     */
    @ApiModelProperty("业务伙伴id business_partner.id")
    private Long partnerId;
}
