package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistBroadcastPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistBroadcastQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistBroadcastVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 广播
 *
 * @author xxb
 * @date 2023-10-07
 */
public interface PmsDistBroadcastService {


    /**
     * 取消广播
     *
     * @param distId
     * @return
     */
    void cancelBroadcast(Long distId);

    /**
     * 登录人未响应过的派发数据（感兴趣和不感兴趣都算响应）
     * @param respondentResId
     * @return
     */
    List<PmsDistBroadcastVO> findListByRespondentResId(Long respondentResId);


    /**
     * 分页查询 广播看板
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsDistBroadcastVO}>
     */
    PagingVO<PmsDistBroadcastVO> queryPaging(PmsDistBroadcastQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsDistBroadcastVO}>
     */
    List<PmsDistBroadcastVO> queryListDynamic(PmsDistBroadcastQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsDistBroadcastVO}
     */
    PmsDistBroadcastVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsDistBroadcastVO}
     */
    PmsDistBroadcastVO insert(PmsDistBroadcastPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsDistBroadcastVO}
     */
    PmsDistBroadcastVO update(PmsDistBroadcastPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsDistBroadcastPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
