package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
import java.math.BigDecimal;
import java.util.List;

/**
 * 预付款收据管理
 *
 * @author wangly
 * @date 2024-05-27
 */
@Getter
@Setter
public class BillVerDetailQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 付款申请单ID 精确 */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /** 票据号 精确 */
    @ApiModelProperty("票据号")
    private String billNo;
    /** 本次核销金额 精确 */
    @ApiModelProperty("本次核销金额")
    private BigDecimal theAmt;
    /** 票据金额 精确 */
    @ApiModelProperty("票据金额")
    private BigDecimal invoiceAmt;
    /** 已核销金额 精确 */
    @ApiModelProperty("已核销金额")
    private BigDecimal writtenOffAmt;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private String rate;
    /** 票据日期 精确 */
    @ApiModelProperty("票据日期")
    private LocalDate invoiceDate;
    /** 关联采购明细Id 精确 */
    @ApiModelProperty("关联采购明细Id")
    private Long purConOrAgreementDetailId;
    /** 关联采购明细Id 精确 */
    @ApiModelProperty("关联采购明细Id")
    private Long purConDetailId;
    /** 票据附件 精确 */
    @ApiModelProperty("票据附件")
    private String fileCode;
    /** jde票据公司 精确 */
    @ApiModelProperty("jde票据公司")
    private String jdecompany;
    /** jde单据号 精确 */
    @ApiModelProperty("jde单据号")
    private String jdedocumentno;
    /** jde单据类型 精确 */
    @ApiModelProperty("jde单据类型")
    private String jdedocumenttype;
    /** jde付款项 精确 */
    @ApiModelProperty("jde付款项")
    private String jdepaymentitem;
    /** jde发票凭证失败原因 精确 */
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeinvoicefailreason;
    /** 预留字段1 精确 */
    @ApiModelProperty("预留字段1")
    private String ext1;
    /** 预留字段2 精确 */
    @ApiModelProperty("预留字段2")
    private String ext2;
    /** 预留字段3 精确 */
    @ApiModelProperty("预留字段3")
    private String ext3;
    /** 预留字段4 精确 */
    @ApiModelProperty("预留字段4")
    private String ext4;
    /** 预留字段5 精确 */
    @ApiModelProperty("预留字段5")
    private String ext5;
    /** 预留字段6 精确 */
    @ApiModelProperty("预留字段6")
    private String ext6;
    /** 预留字段7 精确 */
    @ApiModelProperty("预留字段7")
    private String ext7;
    /** 预留字段8 精确 */
    @ApiModelProperty("预留字段8")
    private String ext8;
}
