package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ExcelIgnoreUnannotated
public class PrintPaySerialNumVO implements Serializable {
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司")
    @ExcelProperty(value = "付款公司", index = 0)
    private String payCompanyBookIdDesc;


    /**
     * 付款流水号
     */
    @ApiModelProperty("付款流水号")
    @ExcelProperty(value = "付款流水号", index = 1)
    private String paySerialNum;

    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单编号")
    @ExcelProperty(value = "付款申请单号", index = 2)
    private String paymentApplyNo;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    @ExcelProperty(value = "申请日期", index = 3)
    private String applicationDateString;

    /**
     * 申请人
     */
    @ExcelProperty(value = "付款申请人", index = 4)
    private String purchaseInchargeResName;

    /**
     * 支付用途/网银用途
     */
    @ApiModelProperty("用途")
    @ExcelProperty(value = "用途", index = 5)
    private String payPurpose;

    @ApiModelProperty("收方名称")
    @ExcelProperty(value = "收方名称", index = 6)
    private String receivingCompanyBookIdDesc;

    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    @ExcelProperty(value = "付款金额", index = 7)
    private BigDecimal paymentAmt;

    /**
     * 计划付款日期
     */
    @ApiModelProperty("计划付款日期")
    @ExcelProperty(value = "计划付款日期", index = 8)
    private String paymentDateString;

}
