package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 预付款核销申请单
 *
 * @author likunpeng
 * @date 2023-12-21
 */
@Data
public class WriteOffPaymentApplyVO {

    /** 付款申请单ID */
    @ApiModelProperty("付款申请单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /** 付款申请单编号 */
    @ApiModelProperty("付款申请单编号")
    private String paymentNo;

    /** 预付款申请单编号 */
    @ApiModelProperty("预付款申请单编号")
    private String prePaymentNo;

    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currPaymentAmt;

    /** 状态 */
    @ApiModelProperty("状态")
    private String state;


}
