package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRoleRefPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRoleRefQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRoleRefVO;

import java.util.List;

/**
 * 通用文档配置 业务类型访问权限
 *
 * @author duwh
 * @date 2023-12-11
 */
public interface BusinessDocTypeConfigRoleRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeConfigRoleRefVO}>
     */
    PagingVO<BusinessDocTypeConfigRoleRefVO> queryPaging(BusinessDocTypeConfigRoleRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeConfigRoleRefVO}>
     */
    List<BusinessDocTypeConfigRoleRefVO> queryListDynamic(BusinessDocTypeConfigRoleRefQuery query);

    /**
     * 计数
     *
     * @param query 查询
     * @return {@link Long}
     */
    Long count(BusinessDocTypeConfigRoleRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeConfigRoleRefVO}
     */
    BusinessDocTypeConfigRoleRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigRoleRefVO}
     */
    BusinessDocTypeConfigRoleRefVO insert(BusinessDocTypeConfigRoleRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigRoleRefVO}
     */
    BusinessDocTypeConfigRoleRefVO update(BusinessDocTypeConfigRoleRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeConfigRoleRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
