package com.elitesland.tw.tw5.api.common.funConfig.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;


/**
  * 通用文档-易稻壳赋权预览地址获取记录表
  *
  * @author duwh
  * @date 2023-12-09
  */
@Getter
@Setter
public class BusinessDocTypePermissionPrevRecordVO extends BaseViewModel implements Serializable {

    /**
     * 是否成功
     */
    private boolean ok = true;
    /** 警告信息 */
    @ApiModelProperty("警告信息")
    private String warnInfo;

    /** 单据类型 */
    @ApiModelProperty("单据类型")
    private String docType;
    /** 单据主键 */
    @ApiModelProperty("单据主键")
    private Long docId;
    /** 被赋权限的人员userId */
    @ApiModelProperty("被赋权限的人员userId")
    private Long userId;
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @ApiModelProperty("文档类型配置主键 prd_business_doc_type_config.id")
    private Long configId;
    /** prd_business_doc_type_config_rule.id */
    @ApiModelProperty("prd_business_doc_type_config_rule.id")
    private Long configRuleId;
    /** 易稻壳libraryId */
    @ApiModelProperty("易稻壳libraryId")
    private String libraryId;
    /** 文件夹id -yeedoc返回 */
    @ApiModelProperty("文件夹id -yeedoc返回")
    private String folderId;
    /** 文件夹名称 LeafName -yeedoc返回 */
    @ApiModelProperty("文件夹名称 LeafName -yeedoc返回")
    private String folderName;
    /** 易稻壳文件路径 */
    @ApiModelProperty("易稻壳文件路径")
    private String itemPath;
    /** 易稻壳文件预览地址 */
    @ApiModelProperty("易稻壳文件预览地址")
    private String previewUri;
    /** 赋权标记 */
    @ApiModelProperty("赋权标记")
    private Boolean permissionFlag;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
