package com.elitesland.tw.tw5.api.prd.adm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 行政订票管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmTripTicketQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 申请id 精确
     */
    @ApiModelProperty("申请id")
    private Long applyId;
    /**
     * 申请单名称 模糊
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 订票费用类型 精确
     */
    @ApiModelProperty("订票费用类型")
    private String ticketExpType;
    /**
     * 出差人资源id 精确
     */
    @ApiModelProperty("出差人资源id")
    private Long tripResId;
    /**
     * 订票人资源id 精确
     */
    @ApiModelProperty("订票人资源id")
    private Long bookingResId;
    /**
     * 出发地 精确
     */
    @ApiModelProperty("出发地")
    private String fromPlace;
    /**
     * 目的地 精确
     */
    @ApiModelProperty("目的地")
    private String toPlace;
    /**
     * 交通工具 精确
     */
    @ApiModelProperty("交通工具")
    private String vehicle;
    /**
     * 出差日期开始 精确
     */
    @ApiModelProperty("出差日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate tripBeginDate;
    /**
     * 出差日期结束 精确
     */
    @ApiModelProperty("出差日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate tripEndDate;
    /**
     * 时间段 精确
     */
    @ApiModelProperty("时间段")
    private String timespan;
    /**
     * 订票日期开始 精确
     */
    @ApiModelProperty("订票日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate bookingBeginDate;
    /**
     * 订票日期结束 精确
     */
    @ApiModelProperty("订票日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate bookingEndDate;
    /**
     * 车次航班 模糊
     */
    @ApiModelProperty("车次航班")
    private String vehicleNo;
    /**
     * 金额 精确
     */
    @ApiModelProperty("金额")
    private BigDecimal expAmt;
    /**
     * 票务使用状态 精确
     */
    @ApiModelProperty("票务使用状态")
    private String useStatus;
    /**
     * 购票渠道 精确
     */
    @ApiModelProperty("购票渠道")
    private String ticketPurchasingChannel;
    /**
     * 报销状态 精确
     */
    @ApiModelProperty("报销状态")
    private String reimbursementStatus;

    @ApiModelProperty("主键集合")
    private List<Long> idList;

    @ApiModelProperty("报销单ID")
    private Long reimId;

}
