package com.elitesland.tw.tw5.api.prd.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 预算科目明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetSubjectDetailPayload extends TwCommonPayload implements Serializable {
    /**
     * 预算ID
     */
    @ApiModelProperty("预算ID")
    private Long budgetId;
    /**
     * 科目ID
     */
    @ApiModelProperty("科目ID")
    private Long accId;
    /**
     * 科目父级ID
     */
    @ApiModelProperty("科目父级ID")
    private Long accParentId;
    /**
     * 原始预算金额
     */
    @ApiModelProperty("原始预算金额")
    private BigDecimal originalAmt;
    /**
     * 预算金额
     */
    @ApiModelProperty("预算金额")
    private BigDecimal budgetAmt;
    /**
     * 已拨付金额
     */
    @ApiModelProperty("已拨付金额")
    private BigDecimal feeReleasedAmt;
    /**
     * 已使用金额
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmt;
    /**
     * 可用金额
     */
    @ApiModelProperty("可用金额")
    private BigDecimal availableAmt;
    /**
     * 占用金额
     */
    @ApiModelProperty("占用金额")
    private BigDecimal occupyAmt;
    /**
     * 费用占比
     */
    @ApiModelProperty("费用占比")
    private BigDecimal amtProportion;

    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;

    @ApiModelProperty("使用费用占比")
    private BigDecimal usedAmtProportion;

    /**
     * 可配置化字段1
     */
    @ApiModelProperty("可配置化字段1")
    private String configurableField1;
    /**
     * 可配置化字段2
     */
    @ApiModelProperty("可配置化字段2")
    private String configurableField2;
    /**
     * 可配置化字段3
     */
    @ApiModelProperty("可配置化字段3")
    private String configurableField3;
    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag = false;
}
