package com.elitesland.tw.tw5.api.prd.budget.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 预算基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
@ToString
public class BudgetVO extends BaseViewModel implements Serializable {
    /**
     * 费用归属：合同项目、BU项目、商机项目
     */
    @ApiModelProperty("费用归属：合同项目、BU项目、商机项目")
    private String sourceType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "sourceType")
    private String sourceTypeDesc;
    /**
     * 费用归属ID
     */
    @ApiModelProperty("费用归属ID")
    private Long sourceId;
    /**
     * 费用归属名称
     */
    @ApiModelProperty("费用归属名称")
    private String sourceName;

    @ApiModelProperty("费用归属编号")
    private String sourceCode;

    /**
     * 预算名称
     */
    @ApiModelProperty("预算名称")
    private String budgetName;
    /**
     * 预算状态：新建、审批中、激活（已审批）、关闭
     */
    @ApiModelProperty("预算状态：新建、审批中、激活（已审批）、关闭")
    private String budgetStatus;
    @UdcName(udcName = "budget:status", codePropName = "budgetStatus")
    private String budgetStatusDesc;
    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;
    /**
     * 流程名字
     */
    @ApiModelProperty("流程名字")
    private String procInstName;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private Integer procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 是否可选择 0 false 不可选择 1 true 可选择
     */
    @ApiModelProperty("是否可选择 0 false 不可选择 1 true 可选择")
    private Boolean selectFlag;
    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    private String budgetCode;

    /**
     * 控制类型：刚性、 柔性 、不控制
     */
    @ApiModelProperty("控制类型：刚性、 柔性 、不控制")
    private String controlType;
    @UdcName(udcName = "BUDGET:CONTROLTYPE", codePropName = "controlType")
    private String controlTypeDesc;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate budgetStartDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate budgetEndDate;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 拓展字段1
     */
    @ApiModelProperty("拓展字段1")
    private String extVarchar1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String extVarchar2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String extVarchar3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String extVarchar4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String extVarchar5;
    /**
     * 拓展字段6
     */
    @ApiModelProperty("拓展字段6")
    private String extVarchar6;
    /**
     * 拓展字段7
     */
    @ApiModelProperty("拓展字段7")
    private String extVarchar7;
    /**
     * 拓展字段8
     */
    @ApiModelProperty("拓展字段8")
    private String extVarchar8;
    /**
     * 拓展字段9
     */
    @ApiModelProperty("拓展字段9")
    private String extVarchar9;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;
    /**
     * 流程定义的KEY
     */
    @ApiModelProperty("流程定义的KEY")
    private String procDefKey;
    /**
     * 预算年度
     */
    @ApiModelProperty("预算年度")
    private String finYear;

    /**
     * 预算总金额
     */
    @ApiModelProperty("预算总金额")
    private BigDecimal totalAmt;
    /**
     * 原始预算总金额
     */
    @ApiModelProperty("原始预算总金额")
    private BigDecimal originalTotalAmt;

    /**
     * 规划费用金额
     */
    @ApiModelProperty("规划费用金额")
    private BigDecimal planAmt;
    /**
     * 原始规划费用金额
     */
    @ApiModelProperty("原始规划费用金额")
    private BigDecimal originalPlanAmt;

    /**
     * 当量预算总数
     */
    @ApiModelProperty("规划当量数")
    private BigDecimal planEqva;
    /**
     * 当量预算总金额
     */
    @ApiModelProperty("规划当量数金额")
    private BigDecimal planEqvaAmt;
    /**
     * 原始当量
     */
    @ApiModelProperty("原始规划当量数")
    private BigDecimal originalPlanEqva;
    /**
     * 原始当量金额
     */
    @ApiModelProperty("原始规划当量数金额")
    private BigDecimal originalPlanEqvaAmt;
    /**
     * 项目、合同 相关信息
     */
    @ApiModelProperty("科目模板ID")
    private Long subjectTempId;
    @ApiModelProperty("科目模板名称")
    private String subjectTempName;
    @ApiModelProperty("总当量（项目侧数据）")
    private BigDecimal totalEqva;
    @ApiModelProperty("费用总预算（项目侧数据）")
    private BigDecimal totalReimbursement;

    @ApiModelProperty("初始项目盈亏平衡最大成本")
    private BigDecimal totalCost;
    @ApiModelProperty("项目盈亏平衡最大成本")
    private BigDecimal totalLastCost;
    @ApiModelProperty("平台提成比例")
    private BigDecimal percentage;
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同总金额")
    private BigDecimal amt;
    @ApiModelProperty("有效合同金额")
    private BigDecimal effectiveAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("销售负责人ID")
    private Long saleManUserId;
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;
    @ApiModelProperty("合同状态")
    private String contractStatus;
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    @ApiModelProperty("工作类型")
    private String workType;
    @ApiModelProperty("平台合同类型")
    private String platType;
    @ApiModelProperty("pmo资源负责人id")
    private Long pmoResId;
    @ApiModelProperty("交付用户id")
    private Long deliUserId;

    @ApiModelProperty("预算科目明细")
    private List<BudgetSubjectDetailVO> subjectDetailVOS;

    @ApiModelProperty("预算科目明细")
    private List<BudgetSubjectDetailVO> subjectDetailVOSTree;

    //    @ApiModelProperty("资源规划周期: WEEK周 MONTH月")
//    private String resourcePlanningCycle;
//    @ApiModelProperty("持续时长")
//    private Integer duration;
//    @ApiModelProperty("资源计划角色明细")
//    private List<PmsResourcePlanRoleVO> resourcePlanRoleVOS;
    @ApiModelProperty("资源计划角色")
    private PersonPlanVO resourcePlanVO;

    @ApiModelProperty("活动明细")
    private List<PmsProjectActivityVO> activityVOS;


    /**
     * 当量相关
     */
    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;
    @ApiModelProperty("占用当量金额")
    private BigDecimal occupyEqvaAmt;
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;
    @ApiModelProperty("已使用当量金额")
    private BigDecimal usedEqvaAmt;
    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;
    @ApiModelProperty("累计投入当量占比=（占用+使用当量）/规划当量数")
    private BigDecimal totalEqvaProportion;

    /**
     * 费用相关
     */
    @ApiModelProperty("占用费用金额")
    private BigDecimal occupyAmt;
    @ApiModelProperty("已使用费用金额")
    private BigDecimal usedAmt;
    @ApiModelProperty("使用费用占比")
    private BigDecimal usedAmtProportion;


    /**
     * 变更
     */
    @ApiModelProperty("变更费用金额")
    private BigDecimal planAmtChange;
    @ApiModelProperty("变更当量数")
    private BigDecimal planEqvaChange;
    @ApiModelProperty("变更当量数金额")
    private BigDecimal planEqvaAmtChange;
    @ApiModelProperty("变更总金额")
    private BigDecimal totalAmtChange;


    @ApiModelProperty("本次变更费用金额")
    private BigDecimal currentPlanAmtChange;
    @ApiModelProperty("本次变更当量数")
    private BigDecimal currentPlanEqvaChange;
    @ApiModelProperty("本次变更当量数金额")
    private BigDecimal currentPlanEqvaAmtChange;
    @ApiModelProperty("本次变更总金额")
    private BigDecimal currentTotalAmtChange;


    @ApiModelProperty("使用总占比")
    private BigDecimal usedTotalProportion;

    @ApiModelProperty("占用总金额=占用当量*当量单价+占用费用")
    private BigDecimal occupyTotalAmt;
    @ApiModelProperty("已使用总金额=使用用当量*当量单价+使用费用")
    private BigDecimal usedTotalAmt;


    /**
     * 变更状态
     */
    private String changeStatus;
    @UdcName(udcName = "budget:changeStatus", codePropName = "changeStatus")
    private String changeStatusName;

    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private Object budgetFilesData;
    /**
     * 是否允许拨付（暂时控制预算是否用完）
     */
    @ApiModelProperty("是否允许拨付")
    private Boolean allocatedFlag = true;

    ////////////////////////////////////////
    /**
     * 拨付相关
     */
    @ApiModelProperty("已拨付费用金额")
    private BigDecimal allocatedAmt;
    @ApiModelProperty("已拨付当量数")
    private BigDecimal allocatedEqva;
    @ApiModelProperty("已拨付当量数金额")
    private BigDecimal allocatedEqvaAmt;
    @ApiModelProperty("已拨付总金额")
    private BigDecimal allocatedTotalAmt;

    @ApiModelProperty("剩余可拨付当量")
    private BigDecimal remainingEqva;
    @ApiModelProperty("剩余可拨付费用")
    private BigDecimal remainingAmt;
    @ApiModelProperty("累计拨付比例")
    private BigDecimal allocatedAppropriation;

    @ApiModelProperty("签单BU_ID")
    private Long signBuId;

    /**
     * 费用承担bu
     */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;
}
