package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * 客户经营-经营团队成员
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmCustomerOperationMemberQuery extends TwQueryParam {

    /**
     * 客户经营主键
     */
    @Query
    private Long operId;

    /**
     * 类型 TEMP 临时授权人员 ...
     */
    @Query
    private String type;

    /**
     * 类型名称
     */
    @Query
    private String typeName;

    /**
     * 用户id
     */
    @Query
    private Long userId;

    /**
     * 用户名字 冗余
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String userName;

    /**
     * 授权开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    /**
     * 授权结束结束
     */
    @Query(type = Query.Type.GREATER_THAN)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    @Query
    private Integer disabledFlag;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

}
