package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsMembersVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreListVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zoey
 * @Description:线索管理
 * @date 2022/5/20 - 16:26
 */
public interface CrmLeadsService {

    CrmLeadsVO saveOne(CrmLeadsPayload payload);

    CrmLeadsVO queryDetail(Long offshreId, Long id);

    void deleteSoft(List<Long> asList);

    void updateFollow(CrmFollowPayload payload);

    void updateMembers(List<CrmLeadsMembersPayload> members);

//    void dynamicUpdate(CrmLeadsPayload payload);

    void dynamicUpdate(CrmLeadsPayload payload, String action);

    Object distributeLeads(CrmLeadsPayload payload);

    void batchDistributeLeads(List<CrmLeadsPayload> payload);


    void receiveLeads(Long key);

    void withdrawLeads(CrmLeadsPayload payload);

    void backLeads(CrmLeadsPayload payload);

//    void transferLeads(CrmLeadsPayload payload);

    void remarkLeads(CrmLeadsPayload payload);

    void batchRemarkLeads(List<CrmLeadsPayload> payloads);

    /**
     * 转商机
     *
     * @param id
     * @param opportunityPayload
     */
    Long toOpportunity(Long id, CrmOpportunityPayload opportunityPayload);

    Map<String, String> queryFields();

//    PagingVO<CrmLeadsListVO> pagingReceive(CrmLeadsQuery query);

    PagingVO<CrmLeadsListVO> pagingOffshoreLeads(CrmLeadsOffshoreQuery query);

    List<CrmOffshoreListVO> getOffshoreList(CrmLeadsOffshoreQuery query);


    List<CrmLeadsListVO> queryListOffshoreLeads(CrmLeadsOffshoreQuery query);

    List<CrmLeadsListVO> queryList(CrmLeadsOffshoreQuery query);

    PagingVO<CrmLeadsListVO> paging(CrmLeadsQuery query);

    Long count(CrmLeadsQuery quer);

    //线索关联业务伙伴分页
    //  PagingVO<CrmLeadPagingVO> pageCrmLeadByQuery(CrmLeadsQuery leadsQuery);

    void transferLeadsUser(CrmLeadsPayload payload);

    void transferLeadsOffshore(CrmLeadsPayload payload);

    void transferLeadsOffshoreBatch(List<CrmLeadsPayload> payloads);

    List<CrmLeadsListVO> queryListMarketLeads(CrmLeadsQuery query);

    PagingVO<CrmLeadsListVO> pageListMarketLeads(CrmLeadsQuery query);

    PagingVO<CrmLeadsListVO> queryListNotReceivedLeadsByUserId(CrmLeadsOffshoreQuery query);

    PagingVO<CrmLeadsListVO> queryListNotDistributedLeadsByUserId(CrmLeadsOffshoreQuery query);

    long countNotReceivedLeadsByUserId(long userId);

    long countNotDistributedLeadsByUserId(long userId);

    void closeLeads(CrmLeadsPayload payload);

    List<CrmLeadsMembersVO> queryMembersList(Long leadsId);

    List<PrdSystemLogVO> queryLogList(Long leadsId, String stage);

//    List<CrmFollowVO> queryFollowList(Long leadsId);

    PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery query);

    boolean isOffshoreAdmin();

    void deleteOffshoreSoft(Long offshoreId, Long newOffshoreId);


    Object pagingPersonalLeads(CrmLeadsQuery query);

    void downloadBatch(HttpServletResponse response, CrmLeadsQuery query);


    void downloadBatchOffshore(HttpServletResponse response, CrmLeadsOffshoreQuery query);

    Map<String, Object> importBatch(HttpServletResponse response, MultipartFile file, Boolean force);

    boolean leadsNotFollowRemind();

    boolean leadsToDistributeRemind();


    void batchAddTags(Long[] keys, String leadsTagIds);

    void batchDelTags(Long[] keys, String leadsTagIds);


    /**
     * 绑定客户
     *
     * @param id
     */
    Map<String, Object> bindCustomer(Long id);

    /**
     * 批量绑定客户
     *
     * @param ids
     */
    void bindCustomerBatch(Long[] ids);


    void bindCustomerNotBind();

    Map<String, Object> bindCustomers();

    boolean leadsNotReceiveRemind(int i);

    /**
     * 根据客户名称查询线索
     * @param customName
     * @return
     */
    List<CrmLeadsListVO> queryListByCustomName(String customName);
}

