package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;


/**
 * @author : WWW
 * @date : 2023-12-2
 * @desc : 试用期考核
 */

@Data
@ApiModel(description = "试用期考核")
public class PrdProbationExamPayload extends TwCommonPayload {


    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long userId;

    /**
     * 用户名
     */
    @ApiModelProperty("用户名")
    private String userName;

    /**
     * baseBU
     */
    @ApiModelProperty("baseBU")
    private Long baseBuId;

    /**
     * 上级
     */
    @ApiModelProperty("上级")
    private Long pUserId;

    /**
     * 上级名称
     */
    @ApiModelProperty("上级名称")
    private String pUserName;

    /**
     * 试用期开始
     */
    @ApiModelProperty("试用期开始")
    private LocalDate probationStart;

    /**
     * 试用期结束
     */
    @ApiModelProperty("试用期结束")
    private LocalDate probationEnd;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 申请人id
     */
    @ApiModelProperty("申请人id")
    private Long applyUserId;

    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private String applyUser;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /**
     * 入职培训标记
     */
    @ApiModelProperty("入职培训标记")
    private Boolean enrollTrainFlag;

    /**
     * 培训说明
     */
    @ApiModelProperty("培训说明")
    private String trainDesc;

    /**
     * 成长收获
     */
    @ApiModelProperty("成长收获")
    private String selfEval1;

    /**
     * 近期工作成果
     */
    @ApiModelProperty("近期工作成果")
    private String selfEval2;

    /**
     * 自我定位
     */
    @ApiModelProperty("自我定位")
    private String selfEval3;

    /**
     * 需要改进的方面
     */
    @ApiModelProperty("需要改进的方面")
    private String selfEval4;

    /**
     * 建议
     */
    @ApiModelProperty("建议")
    private String selfEval5;

    /**
     * 上级评价说明
     */
    @ApiModelProperty("上级评价说明")
    private String pUserEvalDecs;

    /**
     * 上级评价id
     */
    @ApiModelProperty("上级评价id")
    private Long pUserEvalId;

    /**
     * 考核结果
     */
    @ApiModelProperty("考核结果")
    private String examRes;

    /**
     * 转正日期
     */
    @ApiModelProperty("转正日期")
    private LocalDate formalData;

    /**
     * 考核类型(中/末)
     */
    @ApiModelProperty("考核类型(中/末)")
    private String type;

    /**
     * bu负责人评价说明
     */
    @ApiModelProperty("bu负责人评价说明")
    private String baseBuEvalDesc;

    /**
     * bu负责人评价id
     */
    @ApiModelProperty("bu负责人评价id")
    private Long baseBuEvalId;

    /**
     * 完成标记
     */
    @ApiModelProperty("完成标记")
    private Boolean finishFlag;

    /**
     * 考核奖励
     */
    @ApiModelProperty("考核奖励")
    private String examReward;


    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 是否内推
     */
    @ApiModelProperty("是否内推")
    private Boolean recommendFlag;

    /**
     * 内推用户id
     */
    @ApiModelProperty("内推用户id")
    private Long recommendUserId;


    @ApiModelProperty("上级评价")
    private PrdEvaluatePayload pPrdEvaluatePayload;

    @ApiModelProperty("bu评价")
    private PrdEvaluatePayload buPrdEvaluatePayload;

    /**
     * 流程名称
     */
    @ApiModelProperty("流程名称")
    private String name;

    /**
     * 定时标志
     */
    @ApiModelProperty("定时标志")
    private Boolean taskFlag = false;


    public Long getpUserId() {
        return pUserId;
    }

    public void setpUserId(Long pUserId) {
        this.pUserId = pUserId;
    }

    public String getpUserName() {
        return pUserName;
    }

    public void setpUserName(String pUserName) {
        this.pUserName = pUserName;
    }

    public PrdEvaluatePayload getpPrdEvaluatePayload() {
        return pPrdEvaluatePayload;
    }

    public void setpPrdEvaluatePayload(PrdEvaluatePayload pPrdEvaluatePayload) {
        this.pPrdEvaluatePayload = pPrdEvaluatePayload;
    }

    public String getpUserEvalDecs() {
        return pUserEvalDecs;
    }

    public void setpUserEvalDecs(String pUserEvalDecs) {
        this.pUserEvalDecs = pUserEvalDecs;
    }

    public Long getpUserEvalId() {
        return pUserEvalId;
    }

    public void setpUserEvalId(Long pUserEvalId) {
        this.pUserEvalId = pUserEvalId;
    }
}

