package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonWorkExperiencePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonWorkExperienceVO;

import java.util.List;

public interface PersonWorkExperienceService {

    /**
     * 保存工作经历
     *
     * @param payload
     * @return
     */
    void save(PersonWorkExperiencePayload payload);

    /**
     * 查询工作经历列表
     *
     * @param personId
     * @return
     */
    List<PersonWorkExperienceVO> findAllByPersonId(Long personId);

    /**
     * 批量保存工作经历列表
     *
     * @param workExperienceVOList
     * @param personId
     * @return
     */
    void saveAll(List<PersonWorkExperienceVO> workExperienceVOList, Long personId);

    /**
     * 删除资源工作经历
     *
     * @param personId
     * @return
     */
    void deleteAllByPersonId(Long personId);
}


