package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseBuChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;

import java.time.LocalDate;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-3
 * @desc : baseBu变更Service
 */

public interface PrdBaseBuChangeService {

    /**
     * 新增baseBu变更数据
     *
     * @param prdBaseBuChangePayload
     * @return
     */
    PrdBaseBuChangeVO save(PrdBaseBuChangePayload prdBaseBuChangePayload);

    /**
     * 根据主键更新
     *
     * @param prdBaseBuChangePayload
     * @return
     */
    PrdBaseBuChangeVO update(PrdBaseBuChangePayload prdBaseBuChangePayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdBaseBuChangeVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdBaseBuChangeQuery
     * @return
     */
    PagingVO<PrdBaseBuChangeVO> page(PrdBaseBuChangeQuery prdBaseBuChangeQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdBaseBuChangeQuery
     * @return
     */
    List<PrdBaseBuChangeVO> getList(PrdBaseBuChangeQuery prdBaseBuChangeQuery);

    /**
     * 条件更新
     *
     * @param prdBaseBuChangePayload
     */
    Long updateByCondition(PrdBaseBuChangePayload prdBaseBuChangePayload);

    /**
     * 查询给每个待办事项状态判断赋最新值,返回
     *
     * @param dtlList
     */
    void updateState(List<PrdBuChangeTodoVO> dtlList, Long userId);

    /**
     * 根据生效时间和审批状态-修改资源上级等信息
     *
     * @return
     */
    Boolean changeByTask(Long userId, LocalDate joinDate, String param);
}

