package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
public class OfferEntryApplyVO extends BaseViewModel {

    @ApiModelProperty("流程名称")
    private String procInstName;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @ApiModelProperty("personId")
    private Long personId;

    @ApiModelProperty("资源")
    private String personName;

    @ApiModelProperty("offer是否发放")
    private String deliverOffer;

    @ApiModelProperty("offer未发放原因")
    private String noneOfferReason;

    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;

    @ApiModelProperty("组织")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    @ApiModelProperty("主服务地址")
    private String extString5;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "extString5")
    private String baseCityName;

    @ApiModelProperty("上级")
    private Long parentId;
    @UdcName(udcName = "USER", codePropName = "parentId")
    private String parentName;

    @ApiModelProperty("合作方式")
    private String cooperationMode;
    @UdcName(udcName = "org:employee:COOPERATION_MODE", codePropName = "cooperationMode")
    private String cooperationModeName;

    @ApiModelProperty("岗位")
    private String jobs;

    @ApiModelProperty("申请人")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String applyUser;

    @ApiModelProperty("加班人员")
    private String inLieuFlag;

    @ApiModelProperty("参加商务培训")
    private String busiTrainFlag;

    @ApiModelProperty("内部类型：内部资源，外部资源")
    private String extString6;

    @ApiModelProperty("公司")
    private Long bookId;

    @ApiModelProperty("入职类型")
    private String entryType;

    public String getProcInstStatusDesc() {
        if (null == procInstStatus) {
            return "";
        }
        return procInstStatus.getDesc();
    }
}
