package com.elitesland.tw.tw5.api.prd.inv.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Getter
@Setter
public class InvInvoiceVerDetailPayload extends TwCommonPayload implements Serializable {
    /**
     * 付款申请单ID
     */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /**
     * 发票号
     */
    @ApiModelProperty("发票号")
    private String invoiceNo;
    /**
     * 本次核销金额
     */
    @ApiModelProperty("本次核销金额")
    private BigDecimal theAmt;
    /**
     * 发票金额
     */
    @ApiModelProperty("发票金额")
    private BigDecimal invoiceAmt;
    /**
     * 已核销金额
     */
    @ApiModelProperty("已核销金额")
    private BigDecimal writtenOffAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String rate;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invoiceType;
    /**
     * 搜索类型
     */
    @ApiModelProperty("搜索类型")
    private String searchType;
    /**
     * 发票查验状态
     */
    @ApiModelProperty("发票查验状态")
    private String inspection;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private LocalDate invoiceDate;
    /**
     * 发票代码
     */
    @ApiModelProperty("发票代码")
    private String invoiceCode;

    /**
     * 发票凭证
     */
    @ApiModelProperty("发票凭证")
    private String invoiceVoucher;
    /**
     * 本人OR其他 true为本人，false为其他
     */
    @ApiModelProperty("本人OR其他 true为本人，false为其他")
    private Boolean selfFlag;
    /**
     * 2023-12-21新增关联采购明细
     */
    @ApiModelProperty("关联采购明细Id")
    private Long purConOrAgreementDetailId;

    /** 税额 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmount;
}
