package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter
public class TAttendanceRulePayload extends TwCommonPayload implements Serializable {
    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String ruleName;
    /**
     * 规则描述
     */
    @ApiModelProperty("规则描述")
    private String ruleDesc;
    /**
     * 汇报对象
     */
    @ApiModelProperty("汇报对象")
    private String reportToRes;
    /**
     * 规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）
     */
    @ApiModelProperty("规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）")
    private String ruleType;
    /**
     * 规则状态，预留
     */
    @ApiModelProperty("规则状态，预留")
    private String ruleStatus;
    /**
     * 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）
     */
    @ApiModelProperty("超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）")
    private String outRangeRuleWay;
    /**
     * 员工打卡时是否必须拍照，UDC（YESNO）
     */
    @ApiModelProperty("员工打卡时是否必须拍照，UDC（YESNO）")
    private String needPhotoAttendance;
    /**
     * 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）
     */
    @ApiModelProperty("员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）")
    private Integer attendancePatchApplyLimitCount;
    /**
     * 规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）
     */
    @ApiModelProperty("规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）")
    private String ruleEffectiveTime;
    /**
     * 强制打卡
     */
    @ApiModelProperty("强制打卡")
    private String forceAttendance;
}