package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeBlackListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonDetailVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;


public interface PrdOrgPersonService {

    /**
     * 人才库分页查询
     *
     * @param query
     * @return
     */
    PagingVO<PrdOrgPersonVO> paging(PrdOrgPersonQuery query);

    /**
     * 人才库新增
     *
     * @param payload
     * @return
     */
    Long insert(PrdOrgPersonPayload payload);

    /**
     * 人才库信息修改
     *
     * @param entity
     * @return
     */
    void update(PrdOrgPersonDetailVO entity);

    /**
     * 人才库详情查询
     *
     * @param id
     * @return
     */
    PrdOrgPersonDetailVO findById(Long id);

    /**
     * 人才库详情查询
     *
     * @param id
     * @return
     */
    void deleteById(Long id);

    /**
     * 资源入职
     *
     * @param entity
     * @return
     */
    void personEntry(PrdOrgEmployeePayload entity);

    /**
     * 资源入职信息修改
     *
     * @param payload
     * @return
     */
    void personEntryUpdate(PrdOrgEmployeePayload payload);

    /**
     * 根据流程查询资源入职信息流程
     *
     * @param procId
     * @return
     */
    PrdOrgEmployeePayload personEntryQuery(String procId);

    /**
     * 加入黑名单
     *
     * @param personId
     * @return
     */
    void inBlackList(Long personId);

    /**
     * 移出黑名单
     *
     * @param personId
     * @return
     */
    void outBlackList(Long personId);

    /**
     * 黑名单分页查询
     *
     * @param query
     * @return
     */
    PagingVO<EmployeeBlackListVO> queryBlackList(EmployeeBlackListQuery query);


    /**
     * offer入职发放申请列表分页
     *
     * @param offerEntryApplyQuery
     * @return
     */
    PagingVO<OfferEntryApplyVO> offerApplyPage(OfferEntryApplyQuery offerEntryApplyQuery);

    /**
     * offer入职发放申请详情
     *
     * @param applyId
     * @return
     */
    OfferEntryApplyVO queryOfferByKey(Long applyId);

    /**
     * 权限-分页列表
     *
     * @param query
     * @return
     */
    PagingVO<PrdOrgPersonBSVO> permissionPaging(PrdOrgPersonQuery query);

    /**
     * 根据手机号查询个人信息
     *
     * @param recommPhone
     * @return
     */
    PrdOrgPersonVO getByMobile(String recommPhone);

    /**
     * 根据personId查询员工
     *
     * @param
     * @return
     */
    PrdOrgEmployeeVO findEmployeeByPersonId(Long personId);
}
