package com.elitesland.tw.tw5.api.prd.org.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class PrdOrgEmployeeRefVO extends BaseViewModel {


    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("员工ID")
    private Long employeeId;

    @ApiModelProperty("组织id")
    private Long orgId;


    @ApiModelProperty("事业部级别")
    private String buLevel;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("上级员工ID")
    private Long parentId;

    @ApiModelProperty("上级员工名称")
    private String parentName;

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("排序号")
    private Integer sortIndex;
    /**
     * 是否是默认组织 0：是，1：否
     *
     * @return result
     */
    @ApiModelProperty("是否是默认组织")
    private Integer isDefault = 1;
    /**
     * 是否是组织负责人 0：是，1：否
     *
     * @return result
     */
    @ApiModelProperty("是否是组织负责人")
    private Integer isManage = 1;

    @ApiModelProperty("是否有效")
    private Integer statusFlag = 1;
    /**
     * 部门负责人id
     */
    private Long manageId;

    @ApiModelProperty("合作方式")
    private String cooperationMode;


    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

    /**
     * 专业级别
     */
    private String extString1;
    /**
     * 管理级别
     */
    private String extString2;
    /**
     * 专业序列
     */
    private String extString3;
    /**
     * 职位序列
     */
    private String extString4;
    /**
     * 主服务地址
     */
    private String extString5;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "extString5")
    private String baseCityName;
    /**
     * 内部类型
     */
    private String extString6;
    //组织类型
    private String organizationType;
}
