package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
 * 结项检查项配置
 *
 * @author xxb
 * @date 2023-11-27
 */
@Getter
@Setter
public class PmsInspectionItemConfigVO extends BaseViewModel implements Serializable {
    /**
     * 工作类型编号
     */
    @ApiModelProperty("工作类型编号")
    private String workTypeCodes;
    /**
     * 工作类型名称
     */
    @ApiModelProperty("工作类型名称")
    private String workTypeNames;

    /**
     * 检查事项
     */
    @ApiModelProperty("检查事项")
    private String checkItem;
    @UdcName(udcName = "PMS:PROJ_CLOSED:REASON", codePropName = "checkItem")
    private String checkItemDesc;

    /**
     * 检查方式
     */
    @ApiModelProperty("检查方式")
    private String checkMethod;
    @UdcName(udcName = "PMS:PROJ_CLOSED:CHECK_METHOD", codePropName = "checkMethod")
    private String checkMethodDesc;

    /**
     * 检查说明
     */
    @ApiModelProperty("检查说明")
    private String checkDescription;

    /**
     * 结项审批节点
     */
    @ApiModelProperty("结项审批节点")
    private String approvalNodes;
    @ApiModelProperty("结项审批节点名称")
    private String approvalNodeNames;

    @ApiModelProperty("完成状态")
    private Boolean completeStatus;

    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
}
