package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Getter
@Setter
public class PurchaseContractDetailsQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 关联产品 精确 */
    @ApiModelProperty("关联产品")
    private Long relatedProductId;
    /** 采购产品 精确 */
    @ApiModelProperty("采购产品")
    private String productName;
    /** 产品大类id 精确 */
    @ApiModelProperty("产品大类id")
    private Long classId;
    /** 产品小类id 精确 */
    @ApiModelProperty("产品小类id")
    private Long subClassId;
    /** 采购合同id 精确 */
    @ApiModelProperty("采购合同id")
    private Long purchaseContractId;
    /** 采购合同编号 精确 */
    @ApiModelProperty("采购合同编号")
    private String purchaseContractNo;
    /** 数量 精确 */
    @ApiModelProperty("数量")
    private BigDecimal quantity;
    /** 含税单价 精确 */
    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private String taxRate;
    /** 含税总额 精确 */
    @ApiModelProperty("含税总额")
    private BigDecimal taxAmt;
    /** 不含税总额 精确 */
    @ApiModelProperty("不含税总额")
    private BigDecimal taxNotAmt;
    /** 交期 精确 */
    @ApiModelProperty("交期")
    private LocalDateTime deliveryDate;
    /** 说明 精确 */
    @ApiModelProperty("说明")
    private String note;
}
