package com.elitesland.tw.tw5.api.prd.purchase.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 迪博付款发送邮件VO
 *
 * @author likunpeng
 * @date 2024/7/19
 */
@Data
public class DibPaymentSlipEmailVO {

    @ApiModelProperty("付款单记录ID")
    private Long paymentSlipId;

    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;

    @ApiModelProperty("付款申请单号")
    private String paymentNo;

    @ApiModelProperty("供应商bookId")
    private Long supplierLegalBookId;

    @ApiModelProperty("供应商名称")
    private String supplierLegalBookName;

    @ApiModelProperty("付款申请名称")
    private String purchaseName;

    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;

    @ApiModelProperty("付款时间")
    private LocalDateTime payTime;

    @ApiModelProperty("付款申请人")
    private Long purchaseInchargeResId;


}
