package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 销售合同-T&M-服务价格
 *
 * @author sam.li
 * @date 2024-05-07
 */
@Getter
@Setter
public class ConServicePriceQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 合同ID 精确 */
    @ApiModelProperty("合同ID")
    private Long saleConId;
    /** 结算周期 精确 */
    @ApiModelProperty("结算周期")
    private String settlementCycle;
    /** 结算方式 精确 */
    @ApiModelProperty("结算方式")
    private String settlementMethod;
    /** 角色 精确 */
    @ApiModelProperty("角色")
    private String role;
    /** 级别 精确 */
    @ApiModelProperty("级别")
    private String level;
    /** 人天单价 精确 */
    @ApiModelProperty("人天单价")
    private BigDecimal priceDay;
}
