package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
  * 外包费用确认单
  *
  * @author likunpeng
  * @date 2023-04-17
  */
@Getter
@Setter
public class ConEpibolyCostConVO extends BaseViewModel implements Serializable {
    /** 合同ID */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /** 合同编号 */
    @ApiModelProperty("合同编号")
    private String contractCode;
    /** 合同名称 */
    @ApiModelProperty("合同名称")
    private String contractName;
    /** 商机编号 */
    @ApiModelProperty("商机编号")
    private String oppoNo;
    /** 商机ID */
    @ApiModelProperty("商机ID")
    private Long oppoId;
    /** 商机名称 */
    @ApiModelProperty("商机名称")
    private String oppoName;
    /** 外包费用单号 */
    @ApiModelProperty("外包费用单号")
    private String epibolyCostNo;
    /** 申请人 */
    @ApiModelProperty("申请人Id")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    @ApiModelProperty("申请人Name")
    private String applyUserName;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 申请BU */
    @ApiModelProperty("申请BU_Id")
    private Long applyBuId;
    @UdcName(udcName = "BU", codePropName = "applyBuId")
    @ApiModelProperty("申请BU_Name")
    private String applyBuName;
    /** 渠道费用备注 */
    @ApiModelProperty("渠道费用备注")
    private String remark;
    private Long costConIdV4;
    /**外包费用确认明细(一对一关系) */
    @ApiModelProperty("外包费用确认明细")
    private List<ConEpibolyCostConDVO> ConEpibolyCostConDVOS;
}
