package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
 * APP收款计划我的收款及开票相关数量
 *
 * @author carl
 * @date 2024-05-15
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class ConReceivablePlanDataVO extends BaseViewModel implements Serializable {

    /**
     * 类型（1.我的收款，2.我的开票）
     */
    @ApiModelProperty("类型（1.我的收款，2.我的开票）")
    private String type;
    /**
     * 逾期数量
     */
    @ApiModelProperty("逾期数量")
    private long overdueNum;
    /**
     * 近一个月
     */
    @ApiModelProperty("近一个月")
    private long oneMonthNum;
    /**
     * 近一个月
     */
    @ApiModelProperty("近三个月")
    private long threeMonthNum;
    /**
     * 总数
     */
    @ApiModelProperty("总数")
    private long totalNum;
}
