package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSettingPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSettingQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemSettingService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemSettingVO insert(PrdSystemSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemSettingPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemSettingVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemSettingVO> paging(PrdSystemSettingQuery query);

    /**
     * 通过KEY获取系统设置
     *
     * @param key 下拉选择key
     * @return result
     */
    PrdSystemSettingVO getSystemSettingByKey(String key);

    /**
     * 清空系统选择项缓存
     *
     * @return result
     */
    void clearCache();

    List<PrdSystemSettingVO> queryList(PrdSystemSettingQuery query);
}
