package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemShortcutPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemShortcutQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;

import java.util.List;

/**
 * 系统快捷入口
 *
 * @author wangly
 * @date 2024-03-28
 */
public interface PrdSystemShortcutService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemShortcutVO}>
     */
    PagingVO<PrdSystemShortcutVO> queryPaging(PrdSystemShortcutQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemShortcutVO}>
     */
    List<PrdSystemShortcutVO> queryListDynamic(PrdSystemShortcutQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemShortcutVO}
     */
    PrdSystemShortcutVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemShortcutVO}
     */
    PrdSystemShortcutVO insert(PrdSystemShortcutPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemShortcutVO}
     */
    PrdSystemShortcutVO update(PrdSystemShortcutPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdSystemShortcutPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
    /**
     * 查询当前登录人的所有图标
     *
     */
    PrdUserDataVO queryAllIcon();

}
