package com.elitesland.tw.tw5.api.common.funConfig.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Getter
@Setter
public class BusinessDocTypeConfigRulePayload extends TwCommonPayload  implements Serializable {
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @ApiModelProperty("文档类型配置主键 prd_business_doc_type_config.id")
    private Long configId;
    /** 条件 =、 in、not in、..... */
    @ApiModelProperty("条件 =、 in、not in、.....")
    private String conditions;
    /** 条件值 */
    @ApiModelProperty("条件值")
    private String conditionsValue;
    /** 易道壳itemId */
    @ApiModelProperty("易道壳itemId")
    private String itemId;
    /** 易稻壳libraryId */
    @ApiModelProperty("易稻壳libraryId")
    private String libraryId;
    /** 易稻壳libraryId翻译 */
    @ApiModelProperty("易稻壳libraryId翻译")
    private String libraryName;
    /** 易稻壳库下的文件路径 /A/B/C */
    @ApiModelProperty("易稻壳库下的文件路径 /A/B/C")
    private String path;
    /** 文档类型名称（冗余）prd_business_doc_type_config.name */
    @ApiModelProperty("文档类型名称（冗余）prd_business_doc_type_config.name")
    private String configName;
    /** 文档类型编码（冗余）prd_business_doc_type_config.code */
    @ApiModelProperty("文档类型编码（冗余）prd_business_doc_type_config.code")
    private String configCode;
    /** 功能主键(冗余) prd_system_function.id */
    @ApiModelProperty("功能主键(冗余) prd_system_function.id")
    private Long functionId;
    /** 业务对象主键(冗余) prd_business_table.id */
    @ApiModelProperty("业务对象主键(冗余) prd_business_table.id")
    private Long tableId;
    /** 数据库表名(冗余) prd_business_table.table_name */
    @ApiModelProperty("数据库表名(冗余) prd_business_table.table_name")
    private String tableName;
    /** 业务对象字段明细主键(冗余) prd_business_table_fields.id */
    @ApiModelProperty("业务对象字段明细主键(冗余) prd_business_table_fields.id")
    private Long fieldId;
    /** 字段展示名称(冗余) prd_business_table_fields.show_name */
    @ApiModelProperty("字段展示名称(冗余) prd_business_table_fields.show_name")
    private String fieldShowName;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
