package com.elitesland.tw.tw5.api.prd.cal.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
@ToString
public class CalAccountPayload extends TwCommonPayload implements Serializable {
    /**
     * 账号年度
     */
    @ApiModelProperty("账号年度")
    private Integer ledgerYear;
    /**
     * 账户名称
     */
    @ApiModelProperty("账户名称")
    private String ledgerName;
    /**
     * 账户状态(1有效 0无效)
     */
    @ApiModelProperty("账户状态(1有效 0无效)")
    private Integer ledgerStatus;
    /**
     * （账户类型）核算主体类型(组织，项目，资源,商机)
     */
    @ApiModelProperty("（账户类型）核算主体类型")
    private String auType;
    /**
     * 核算主体id
     */
    @ApiModelProperty("核算主体id")
    private Long auId;
    /**
     * 账号编号
     */
    @ApiModelProperty("账号编号")
    private String ledgerNo;
    private String ledgerType;
    /**
     * 币种
     */

    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal totalQty;
    /**
     * 冻结数量
     */
    @ApiModelProperty("冻结数量")
    private BigDecimal frozenQty;
    /**
     * 可用数量
     */
    @ApiModelProperty("可用数量")
    private BigDecimal avalQty;
    /**
     * 总金额
     */
    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;
    /**
     * 冻结金额
     */
    @ApiModelProperty("冻结金额")
    private BigDecimal frozenAmt;
    /**
     * 可用金额
     */
    @ApiModelProperty("可用金额")
    private BigDecimal avalAmt;

    /**
     * 校验当量
     */
    @ApiModelProperty("校验当量")
    private BigDecimal checkQty;
    /**
     * 校验金额
     */
    @ApiModelProperty("校验金额")
    private BigDecimal checkAmt;
}
