package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Getter
@Setter
public class CrmOpportunityReviewQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 商机id */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /** 风险类型 精确 */
    @ApiModelProperty("风险类型")
    private String riskType;
    /** 风险点描述 精确 */
    @ApiModelProperty("风险点描述")
    private String riskDesc;
    /** 应对计划 精确 */
    @ApiModelProperty("应对计划")
    private String answerPlan;
    /** 计划结束时间 精确 */
    @ApiModelProperty("计划结束时间")
    private LocalDate planEndTime;
    /** 负责人 精确 */
    @ApiModelProperty("负责人")
    private Long directorUserId;
    /** 已完成、未完成、进行中 精确 */
    @ApiModelProperty("已完成、未完成、进行中")
    private String finishState;
}
