package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityCompetitorPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityCompetitorVO;

import java.util.List;


/**
 * @author carl.wang
 * @Description:商机竞争对手管理
 */
public interface CrmOpportunityCompetitorService {

    /**
     * @param payload
     * @Description 新增
     **/
    CrmOpportunityCompetitorVO insert(CrmOpportunityCompetitorPayload payload);

    /**
     * @param payload
     * @Description 修改
     **/
    Long update(CrmOpportunityCompetitorPayload payload);


    /**
     * @param oppoId 商机id
     * @return
     * @Description 列表查询
     **/
    List<CrmOpportunityCompetitorVO> queryList(Long oppoId);


    /**
     * @param keys   主键
     * @param oppoId 商机id
     * @Description 删除
     **/
    boolean deleteSoft(Long oppoId, List<Long> keys);

}

