package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
@Getter
@Setter
public class TBusiSignetApplyPayload extends TwCommonPayload  implements Serializable {
    /** BaseBU */
    @ApiModelProperty("BaseBU")
    private Long basebuId;
    /** 所属公司 */
    @ApiModelProperty("所属公司")
    private Long ouId;
    /** 联系电话 */
    @ApiModelProperty("联系电话")
    private String phone;
    /** 邮箱 */
    @ApiModelProperty("邮箱")
    private String email;
    /** 印章场景 COM:SIGNET_SCENE*/
    @ApiModelProperty("印章场景 udc[COM:SIGNET_SCENE]")
    private String signetScene;
    /** 是否需要打印 */
    @ApiModelProperty("是否需要打印 1是0否")
    private Boolean printFlag;
    /** 印章类型 */
    @ApiModelProperty("印章类型 udc[COM:SIGNET_TYPE]")
    private String signetType;
    /** 相关印章 */
    @ApiModelProperty("相关印章 可多选 udc[COM:RELATED_SIGNET]")
    private String relatedSignet;
    /** 印章所属公司 */
    @ApiModelProperty("印章所属公司 udc[COM:SIGNET_BELONG_COMPANY]")
    private String signetBelongCompany;
    /** 印章用途 */
    @ApiModelProperty("印章用途")
    private String signetPurpose;
    /** 申请印章 */
    @ApiModelProperty("申请印章")
    private String signetApply;
    /** 是否外借 */
    @ApiModelProperty("是否外借")
    private Boolean lendFlag;
    /** 附件 */
    @ApiModelProperty("附件")
    private String fileCode;
    /** 印章归还说明 */
    @ApiModelProperty("印章归还说明")
    private String signetReturnRemark;
    /** 申请人 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /** 预计归还时间 */
    @ApiModelProperty("预计归还时间")
    private LocalDate predictReturnTime;
    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    @ApiModelProperty("流程提交标志")
    private Boolean submit;
}
