package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRefVO;

import java.util.List;

/**
 * 分级策略业务伙伴映射关系
 *
 * @author wanlgy
 * @date 2023-06-19
 */
public interface BusinessStrategyRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyRefVO}>
     */
    PagingVO<BusinessStrategyRefVO> queryPaging(BusinessStrategyRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyRefVO}>
     */
    List<BusinessStrategyRefVO> queryListDynamic(BusinessStrategyRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyRefVO}
     */
    BusinessStrategyRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyRefVO}
     */
    BusinessStrategyRefVO insert(BusinessStrategyRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyRefVO}
     */
    BusinessStrategyRefVO update(BusinessStrategyRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增
     *
     * @param payloadList 单据数据集合
     * @param strategyId 分级策略id business_strategy.id
     */
    void saveAll(List<BusinessStrategyRefPayload> payloadList, Long strategyId);

    /**
     * 通过分级策略id(strategyId)查询
     *
     * @param strategyId business_strategy.id 分级策略id
     * @return {@link List<BusinessStrategyRefVO>}
     */
    List<BusinessStrategyRefVO> queryListByStrategyId(Long strategyId);

    /**
     * 根据主表id删除明细
     *
     * @param strategyId 主表主键
     */
    void deleteSoftByStrategyId(Long strategyId);

    /**
     *  根据策略id查询指定的业务伙伴信息
     *
     * @param strategyId 主表主键
     * */
    List<BusinessStrategyCustomerVO> queryAppointCustomerInfoByStrategyId(Long strategyId);
}
