package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
@Getter
@Setter
public class PmsProjectSummaryPayload extends TwCommonPayload implements Serializable {
    /**
     * 纪要编号
     */
    @ApiModelProperty("纪要编号")
    private String summaryNo;
    /**
     * 纪要名称
     */
    @ApiModelProperty("纪要名称")
    private String summaryName;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;

    /**
     * 消息内容
     */
    @ApiModelProperty("消息内容")
    private String summaryContent;
    /**
     * 状态（0：已保存；1：已发布）
     */
    @ApiModelProperty("状态（0：已保存；1：已发布）")
    private Integer summaryStatus;

    /**
     * 记录日期
     */
    @ApiModelProperty("记录日期")
    private LocalDate summaryDate;
}
