package com.elitesland.tw.tw5.api.prd.pms.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
@SearchBean(
        tables = "pms_project_summary s " +
                "left join pms_project pp on s.proj_id = pp.id " +
                "left join sale_con_contract cc on pp.contract_id = cc.id ",
        where = "s.delete_flag = 0",
        groupBy = ":groupBy:",
        autoMapTo = "s"
)
@Data
public class PmsProjectSummaryVO extends BaseViewModel implements Serializable {
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @UdcName(udcName = "USER", codePropName = "createUserId")
    @DbIgnore
    private String createUserName;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    @UdcName(udcName = "USER", codePropName = "modifyUserId")
    @DbIgnore
    private String modifyUserName;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 纪要编号
     */
    @ApiModelProperty("纪要编号")
    private String summaryNo;
    /**
     * 纪要名称
     */
    @ApiModelProperty("纪要名称")
    private String summaryName;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @DbField(mapTo = "pp")
    private String projName;
    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    @DbField(mapTo = "pp")
    private String projNo;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    @DbField(mapTo = "pp")
    private Long pmResId;
    @UdcName(udcName = "USER", codePropName = "pmResId")
    @DbIgnore
    private String pmResName;

    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    @DbField(mapTo = "pp")
    private Long deliBuId;
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    @DbIgnore
    private String deliBuName;

    /**
     * 交付负责人
     */
    @ApiModelProperty("交付负责人")
    @DbField(mapTo = "pp")
    private Long deliUserId;
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    @DbIgnore
    private String deliUserName;

    /**
     * 消息内容
     */
    @ApiModelProperty("消息内容")
    private String summaryContent;
    /**
     * 状态（0：已保存；1：已发布）
     */
    @ApiModelProperty("状态（0：已保存；1：已发布）")
    private Integer summaryStatus;

    /**
     * 记录日期
     */
    @ApiModelProperty("记录日期")
    private LocalDate summaryDate;

    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    @DbField(mapTo = "cc")
    private String workType;
}
