package com.elitesland.tw.tw5.api.prd.task.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskSettleTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;

import java.util.List;

/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
public interface TaskSettleTimesheetService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskSettleTimesheetVO}>
     */
    PagingVO<TaskSettleTimesheetVO> queryPaging(TaskSettleTimesheetQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskSettleTimesheetVO}>
     */
    List<TaskSettleTimesheetVO> queryListDynamic(TaskSettleTimesheetQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskSettleTimesheetVO}
     */
    TaskSettleTimesheetVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskSettleTimesheetVO}
     */
    TaskSettleTimesheetVO batchInsert(List<TaskSettleTimesheetPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskSettleTimesheetVO}
     */
    TaskSettleTimesheetVO update(TaskSettleTimesheetPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TaskSettleTimesheetPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
