package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 任务包
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
public class CalTaskSettleDetailVO extends BaseViewModel implements Serializable {
    /**
     * 结算单id
     */
    @ApiModelProperty("结算单id")
    private Long settleId;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    /**
     * 项目名称（冗余）
     */
    @ApiModelProperty("项目名称（冗余）")
    private String projName;
    /**
     * 任务名称（冗余）
     */
    @ApiModelProperty("任务名称（冗余）")
    private String taskName;
    /**
     * 任务状态（冗余）
     */
    @ApiModelProperty("任务状态（冗余）")
    private String taskStatus;
    @UdcName(udcName = "PMS:TASK:STATUS", codePropName = "taskStatus")
    private String taskStatusDesc;
    /**
     * 计划开始日期
     */
    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    /**
     * 计划结束日期
     */
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    /**
     * 派发当量
     */
    @ApiModelProperty("派发当量")
    private BigDecimal distedEqva;
    /**
     * 已结算当量
     */
    @ApiModelProperty("已结算当量")
    private BigDecimal settledEqva;
    /**
     * 申请结算当量数
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 快照完工百分比
     */
    @ApiModelProperty("快照完工百分比")
    private BigDecimal ssCompPercent;
    /**
     * 申请结算百分比
     */
    @ApiModelProperty("申请结算百分比")
    private BigDecimal applySettlePercent;
    /**
     * 申请结算总额
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 实际结算当量数
     */
    @ApiModelProperty("实际结算当量数")
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 结算说明
     */
    @ApiModelProperty("结算说明")
    private String settleDesc;
}
