package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigVO;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置表Service
 */

public interface PrdEvaluateConfigService {

    /**
     * 新增评价配置表数据
     *
     * @param prdEvaluateConfigPayload
     * @return
     */
    PrdEvaluateConfigVO save(PrdEvaluateConfigPayload prdEvaluateConfigPayload);

    /**
     * 根据主键更新
     *
     * @param prdEvaluateConfigPayload
     * @return
     */
    PrdEvaluateConfigVO update(PrdEvaluateConfigPayload prdEvaluateConfigPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdEvaluateConfigVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdEvaluateConfigQuery
     * @return
     */
    PagingVO<PrdEvaluateConfigVO> page(PrdEvaluateConfigQuery prdEvaluateConfigQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdEvaluateConfigQuery
     * @return
     */
    List<PrdEvaluateConfigVO> getList(PrdEvaluateConfigQuery prdEvaluateConfigQuery);

    /**
     * 根据条件修改
     *
     * @param prdEvaluateConfigPayload
     * @return
     */
    Long updateByCondition(PrdEvaluateConfigPayload prdEvaluateConfigPayload);

    /**
     * 根据条件查询评价主数据
     *
     * @param prdEvaluateConfigQuery
     * @return
     */
    PrdEvaluateConfigVO getByCondition(PrdEvaluateConfigQuery prdEvaluateConfigQuery);
}

