package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRangeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRangeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRangeSettingVO;

import java.util.List;

/**
 * 分级策略范围配置
 *
 * @author wangly
 * @date 2023-06-16
 */
public interface BusinessStrategyRangeSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyRangeSettingVO}>
     */
    PagingVO<BusinessStrategyRangeSettingVO> queryPaging(BusinessStrategyRangeSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyRangeSettingVO}>
     */
    List<BusinessStrategyRangeSettingVO> queryListDynamic(BusinessStrategyRangeSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyRangeSettingVO}
     */
    BusinessStrategyRangeSettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyRangeSettingVO}
     */
    BusinessStrategyRangeSettingVO insert(BusinessStrategyRangeSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyRangeSettingVO}
     */
    BusinessStrategyRangeSettingVO update(BusinessStrategyRangeSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyRangeSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增
     *
     * @param payloadList 单据数据集合
     * @param strategyId 分级策略id business_strategy.id
     */
    void saveAll(List<BusinessStrategyRangeSettingPayload> payloadList,Long strategyId);

    /**
     * 通过strategyId查询
     *
     * @param strategyId business_strategy.id
     * @return {@link List<BusinessStrategyRangeSettingVO>}
     */
    List<BusinessStrategyRangeSettingVO> queryListByStrategyId(Long strategyId);

    /**
     * 根据主表id删除明细
     *
     * @param strategyId 主表主键
     */
    void deleteSoftByStrategyId(Long strategyId);
}
