package com.elitesland.tw.tw5.api.prd.pms.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 项目预实对照
 *
 * @author carl
 * @date 2023-09-19
 */
@Getter
@Setter
public class PmsPersonPlanAndActualVO {

    //资源规划内容字段

    /**
     * 复合能力级别ID
     */

    @ApiModelProperty("复合能力级别ID")
    private Long capasetLevelId;

    @ApiModelProperty("规划复合能力级别")
    private String capasetLevelIdDesc;

    /**
     * 资源
     */
    @ApiModelProperty("规划资源")
    private Long resId;


    /**
     * 资源
     */
    @ApiModelProperty("规划资源")
    private String resName;

    /**
     * 派发系数
     */

    @ApiModelProperty("规划当量系数")
    private BigDecimal distributeRate;
    /**
     * 汇总当量
     */
    @ApiModelProperty("规划总当量")
    private BigDecimal totalEqva;


    /**
     * 人天合计
     */
    @ApiModelProperty("规划总人天")
    private BigDecimal days;

    // 实际



    /**
     * 实际资源Id
     */
    @ApiModelProperty("实际资源Id")
    private Long actResId;

    @ApiModelProperty("实际资源")
    private String actResName;

    @ApiModelProperty("实际级别")
    private String actGrade;

    @ApiModelProperty("实际当量系数")
    private BigDecimal actDistributeRate;

    @ApiModelProperty("实际总人天")
    private BigDecimal actDays;

    @ApiModelProperty("实际总当量")
    private BigDecimal actTotalEqva;

    @ApiModelProperty("实际与预实对照json")
    private String contentJson;
}
