package com.elitesland.tw.tw5.api.prd.task.service;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;

import java.math.BigDecimal;
import java.util.List;

public interface TaskCommonService {

    /**
     * 根据事由查询 任务
     *
     * @param reasonType
     * @param reasonId
     * @return
     */
//    List<TaskInfoVO> queryTaskByReason(String reasonType, Long reasonId);

    /**
     * 任务包数量
     *
     * @param taskPackageQuery
     * @return
     */
    long taskPackageCount(TaskPackageQuery taskPackageQuery);

    /**
     * 查询任务包列表
     *
     * @param taskPackageQuery
     * @return
     */
    List<TaskPackageVO> queryTaskPackageList(TaskPackageQuery taskPackageQuery);

    /**
     * 工时提交或审批操作调用
     * 提交或审批通过工时传正数
     * 撤回或驳回传负数
     *
     * @param taskId   任务id
     * @param userId   接包人Userid
     * @param type     操作类型（ 1：提交或提交撤回，2：审批通过或审批通过撤回）
     * @param workHour 填写工时数
     */
    void updateTimeSheet(TimesheetPayload timesheetPayload, Long taskId, Long userId, BigDecimal workHour, String type);

    /**
     * 帮我吧工时提交校验及初始化任务包，任务，成员数据
     *
     * @param payloads 工时提交数据
     * @return（工时对应的任务包id，任务包名称，任务id，任务名称）
     */
    List<TimesheetVO> bw8TimeSheetSubmit(List<TimesheetPayload> payloads);

    /**
     * 查询事由下人员工时提交数据
     *
     * @param reasonType
     * @param reasonId
     * @param userIds
     * @return
     */
    List<TimesheetVO> queryTimeSheets(String reasonType, Long reasonId, List<Long> userIds);

    /**
     * 批量创建任务包
     *
     * @param reasonType
     * @param reasonId
     * @param userIds
     */
    void batchCreatTaskPackage(String reasonType, Long reasonId, List<Long> userIds, Object project);

}
