package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleDetailPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
public interface CalTaskSettleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalTaskSettleVO}>
     */
    PagingVO<CalTaskSettleVO> queryPaging(CalTaskSettleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalTaskSettleVO}>
     */
    List<CalTaskSettleVO> queryListDynamic(CalTaskSettleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalTaskSettleVO}
     */
    CalTaskSettleVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link CalTaskSettleVO}
     */
    CalTaskSettleVO insertOrUpdate(CalTaskSettlePayload payload);


    /**
     * 流程中数据修改
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateFlow(CalTaskSettlePayload payload);

    /**
     * 数据单字段修改操作
     *
     * @param payload
     */
    long updateByKeyDynamic(CalTaskSettlePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 调整结算期间
     *
     * @param keys 主键集合
     */
    void updateSettleDate(List<Long> keys, LocalDate settleDate);

    /**
     * 任务结算单提现操作
     *
     * @param payload
     */
    void taskSettleWithdraw(CalTaskSettleWithdrawPayload payload);

    /**
     * 任务包结算单解冻申请
     *
     * @param keys 主键集合
     */
    void unFreezeTaskSettleApply(List<Long> keys);

    /**
     * 定时执行任务结算
     *
     * @param userIds 结算员工userId;
     */
    void taskSettleJobHandler(List<Long> userIds);

    /**
     * 自动结算方法
     *
     * @param taskInfoMaps
     * @param taskPackageVOS
     * @param isNew          是否用最新的日期作为结算期间
     */
    List<CalTaskSettleDetailPayload> taskAutoSettle(Map<Long, List<TaskInfoVO>> taskInfoMaps, List<TaskPackageVO> taskPackageVOS, Boolean isNew);

    /**
     * 保存工时任务结算单关系
     *
     * @param taskSettleIdMap
     */
    public void saveTaskTaskSettleTimesheet(Map<Long, Long> taskSettleIdMap);

    /**
     * 反向结算
     *
     * @param taskNo  任务编号
     * @param eqvaNum 结算当量
     */
    void reverseTaskSettle(String taskNo, BigDecimal eqvaNum, String message);


}
