package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalSettlePriceVO extends BaseViewModel implements Serializable {
    /**
     * from bu结算类型码
     */
    @ApiModelProperty("from bu结算类型码")
    private String fromBuDealtype;
    @UdcName(udcName = "org:manage:BU_SETTLE_TYPE", codePropName = "fromBuDealtype")
    private String fromBuDealtypeDesc;

    /**
     * to bu结算类型码
     */
    @ApiModelProperty("to bu结算类型码")
    private String toBuDealtype;
    @UdcName(udcName = "org:manage:BU_SETTLE_TYPE", codePropName = "toBuDealtype")
    private String toBuDealtypeDesc;
    /**
     * from bu_id
     */
    @ApiModelProperty("from bu_id")
    private Long fromBuId;
    @UdcName(udcName = "BU", codePropName = "fromBuId")
    private String fromBuName;
    /**
     * to bu_id
     */
    @ApiModelProperty("to bu_id")
    private Long toBuId;
    @UdcName(udcName = "BU", codePropName = "toBuId")
    private String toBuName;
    /**
     * 工种
     */
    @ApiModelProperty("工种")
    private String jobType1;
    @UdcName(udcName = "org:employee:multiCapacity", codePropName = "jobType1")
    private String jobType1Desc;
    /**
     * 工种子类
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    @UdcName(udcName = "org:employee:multiCapacity", codePropName = "jobType2")
    private String jobType2Desc;
    /**
     * 核算年度
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private String finPeriodName;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;
    @UdcName(udcName = "USER", codePropName = "resId")
    private String resName;

    /**
     * 定价策略（mark up百分比，mark up金额，绝对结算金额）
     */
    @ApiModelProperty("定价策略（mark up百分比，mark up金额，绝对结算金额）")
    private String priceStrategy;
    @UdcName(udcName = "CAL:PRICE:STRATEGY", codePropName = "priceStrategy")
    private String priceStrategyDesc;
    /**
     * 调整价格（mark up百分比，mark up金额，绝对结算金额）
     */
    @ApiModelProperty("调整价格（mark up百分比，mark up金额，绝对结算金额）")
    private BigDecimal markupPrice;
}
