package com.elitesland.tw.tw5.api.prd.copartner.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeUserDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeUserDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeUserDetailVO;

import java.util.List;

/**
 * 合伙人绩效自述表
 *
 * @author carl
 * @date 2024-06-24
 */
public interface PerformanceReadmeUserDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PerformanceReadmeUserDetailVO}>
     */
    PagingVO<PerformanceReadmeUserDetailVO> queryPaging(PerformanceReadmeUserDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PerformanceReadmeUserDetailVO}>
     */
    List<PerformanceReadmeUserDetailVO> queryListDynamic(PerformanceReadmeUserDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PerformanceReadmeUserDetailVO}
     */
    PerformanceReadmeUserDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PerformanceReadmeUserDetailVO}
     */
    PerformanceReadmeUserDetailVO insert(PerformanceReadmeUserDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PerformanceReadmeUserDetailVO}
     */
    PerformanceReadmeUserDetailVO update(PerformanceReadmeUserDetailPayload payload);

//    /**
//     * 修改,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 单据数据
//     * @return {@link long}
//     */
//    long updateByKeyDynamic(PerformanceReadmeUserDetailPayload payload);

//    /**
//     * 逻辑删除
//     *
//     * @param keys 主键集合
//     */
//    void deleteSoft(List<Long> keys);

    /**
     * 根据配置员工id逻辑删除
     *
     * @param configUserId 主键
     */
    void deleteSoftByConfigUserId(Long configUserId);
}
