package com.elitesland.tw.tw5.api.prd.inv.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Getter
@Setter
public class InvInvoiceVerDetailQuery extends TwQueryParam implements Serializable{
    /** 付款申请单ID 精确 */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /** 发票号 精确 */
    @ApiModelProperty("发票号")
    private String invoiceNo;
    /** 本次核销金额 精确 */
    @ApiModelProperty("本次核销金额")
    private BigDecimal theAmt;
    /** 发票金额 精确 */
    @ApiModelProperty("发票金额")
    private BigDecimal invoiceAmt;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private String rate;
    /** 发票类型 精确 */
    @ApiModelProperty("发票类型")
    private String invoiceType;
    /** 搜索类型 精确 */
    @ApiModelProperty("搜索类型")
    private String searchType;
    /** 发票查验状态 精确 */
    @ApiModelProperty("发票查验状态")
    private String inspection;
    /** 发票日期 精确 */
    @ApiModelProperty("发票日期")
    private LocalDate invoiceDate;
    /** 发票代码 精确 */
    @ApiModelProperty("发票代码")
    private String invoiceCode;
    /** 本人OR其他 true为本人，false为其他 */
    @ApiModelProperty("本人OR其他 true为本人，false为其他")
    private Boolean selfFlag;
}
